#!/usr/bin/env python
"""
Oto najnowsze wiadomoci.
Teleprompter oparty na Raspberry Pi, test 1
"""
import time                     # Na potrzeby dodawania opnie
import os, pygame, sys

pygame.init()                   # Inicjowanie interfejsu graficznego
os.environ['SDL_VIDEO_WINDOW_POS'] = 'center'
pygame.display.set_caption("Teleprompter, test 1.")
screenWidth = 980
screenHeight =610
screen = pygame.display.set_mode([screenWidth,screenHeight],0,32)
background = pygame.Surface((screenWidth,screenHeight))
segments = 4
segment = 0 # Pocztkowy punkt
textHeight = screenHeight / segments
textSurface = [ pygame.Surface((screenWidth,textHeight)) for s in range(0,segments+1)]

# Definiowanie kolorw interfejsu uytkownika
cBackground =(0,0,0)
cText = (255,255,255)
background.fill(cBackground) # Okrelanie koloru ta
font = pygame.font.Font(None, textHeight)

def main():
   lines = 5
   while True :
         for i in range(0,5):
            setWords("To wiersz numer "+str(lines-i),i)
         lines += 1   
         for offset in range(0, textHeight,4): 
            checkForEvent()
            #time.sleep(0.1)
            drawScreen(offset)
     
def drawScreen(offset) : # Wywietlanie na ekranie
    global segment
    screen.blit(background,[0,0]) # Okrelanie koloru ta
    for index in range(0,segments+1):
      segment +=1
      if(segment > segments): # Zerowanie numeru segmentu
         segment = 0
      drawWords(segment,offset)
    pygame.display.update()
 
def setWords(words,index) :
        textSurface[index] = font.render(words, True, cText, cBackground )

def drawWords(index,offset) :
        textRect = textSurface[index].get_rect()
        textRect.centerx = screenWidth / 2
        textRect.top = screenHeight - (textHeight * index) - offset   
        screen.blit(textSurface[index], textRect)
        
def terminate(): # Zamykanie programu
    print ("Trwa zamykanie programu - prosimy czeka")
    pygame.quit() # Usuwanie obiektu pygame
    sys.exit()
    
def checkForEvent(): # Sprawdzanie, czy naley zamkn program
    event = pygame.event.poll()
    if event.type == pygame.QUIT :
           terminate()
    if event.type == pygame.KEYDOWN and event.key == pygame.K_ESCAPE :
            terminate()
            
            
if __name__ == '__main__':
    main()   
